/*
 * @(#)ActivityDiagram.java  1.0  2006-01-18
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.am.diagram;

import ch.hslu.cm.am.model.*;
import ch.hslu.cm.simulation.*;
import ch.hslu.cm.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.*;

/**
 * Holds an Activity Diagram.
 *
 * @author Werner Randelshofer, Florian Padrun
 * @version 1.0 2006-01-18  Created.
 */
public class ActivityDiagram extends AbstractDiagram {
    /** Default colors for figures in this diagram. */
    public final static Color
            FILL_COLOR = new Color(0x90c6ff),
            STROKE_COLOR = new Color(0x1b1b1b),
            ACTIVITY_FINAL_NODE_FILL_COLOR = new Color(0x000000),
            INITIAL_NODE_FILL_COLOR = new Color(0x000000),
            TEXT_COLOR = new Color(0x030303);
    
    public final static double STROKE_WIDTH = 2d;
    
    /**
     * Layers for Figures in this diagram.
     * We wan't all activities to appear below the lines that connect the activities.
     */
    public final static int ACTIVITY_LAYER = 0;
    public final static int CONNECTION_LAYER = 1;
    
    /** Creates a new instance. */
    public ActivityDiagram() {
        this(new ActivityModel());
    }
    
    public ActivityDiagram(ActivityModel simulation) {
        setSimulation(simulation);
    }
    public ActivityModel getActivityModel() {
        return (ActivityModel) getSimulation();
    }
    
    protected DiagramFigure createDiagramFigure(SimulatedElement simElem) {
        // Leave this method empty. We only need to implement this method,
        // if we want to simulate an Activity model.
        return null;
    }
}
